package gov.va.genisis2.dto;

import java.io.Serializable;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;

@JsonInclude(Include.NON_NULL)
@JsonIgnoreProperties({"dispLastRefreshed", "numAdmins"})
public class UserCountDTO implements Serializable {

	private static final long serialVersionUID = -112652092184013502L;
	
	private Date lastRefreshed;
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd@HH:mm:ss.SSSZ")
	private Date dispLastRefreshed;
	private long totalUsers;
	private long numAdmins;
	private long numRequesters;
	private long numDDMs;
	private long numDSMs;
	/**
	 * @return the lastRefreshed
	 */
	public Date getLastRefreshed() {
		return lastRefreshed;
	}
	/**
	 * @param lastRefreshed the lastRefreshed to set
	 */
	public void setLastRefreshed(Date lastRefreshed) {
		this.lastRefreshed = lastRefreshed;
	}
	/**
	 * @return the dispLastRefreshed
	 */
	public Date getDispLastRefreshed() {
		return dispLastRefreshed;
	}
	/**
	 * @param dispLastRefreshed the dispLastRefreshed to set
	 */
	public void setDispLastRefreshed(Date dispLastRefreshed) {
		this.dispLastRefreshed = dispLastRefreshed;
	}
	/**
	 * @return the totalUsers
	 */
	public long getTotalUsers() {
		return totalUsers;
	}
	/**
	 * @param totalUsers the totalUsers to set
	 */
	public void setTotalUsers(long totalUsers) {
		this.totalUsers = totalUsers;
	}
	/**
	 * @return the numAdmins
	 */
	public long getNumAdmins() {
		return numAdmins;
	}
	/**
	 * @param numAdmins the numAdmins to set
	 */
	public void setNumAdmins(long numAdmins) {
		this.numAdmins = numAdmins;
	}
	/**
	 * @return the numRequesters
	 */
	public long getNumRequesters() {
		return numRequesters;
	}
	/**
	 * @param numRequesters the numRequesters to set
	 */
	public void setNumRequesters(long numRequesters) {
		this.numRequesters = numRequesters;
	}
	/**
	 * @return the numDDMs
	 */
	public long getNumDDMs() {
		return numDDMs;
	}
	/**
	 * @param numDDMs the numDDMs to set
	 */
	public void setNumDDMs(long numDDMs) {
		this.numDDMs = numDDMs;
	}
	/**
	 * @return the numDSMs
	 */
	public long getNumDSMs() {
		return numDSMs;
	}
	/**
	 * @param numDSMs the numDSMs to set
	 */
	public void setNumDSMs(long numDSMs) {
		this.numDSMs = numDSMs;
	}
}
